//
//  Script.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//


import Foundation

public struct Script {
    public var entries: [String]
    public var success: String
    public var tryAgain: String
    
    public var index = -1
    
    public init(_ passages: [String], success: String = "", tryAgain: String = "") {
        entries = passages
        self.success = success
        self.tryAgain = tryAgain
    }
    
    public func hasNext() -> Bool {
        return index + 1 < entries.count
    }
    
    public func hasPrevious() -> Bool {
        return index - 1 >= 0
    }
    
    public mutating func next() -> String {
        guard hasNext() else {
            return entries[index]
        }
        index += 1
        return entries[index]
    }
    
    public mutating func previous() -> String {
        guard hasPrevious() else {
            return entries[index]
        }
        index -= 1
        return entries[index]
    }
    
}
